/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.empreintes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatEmpreinteMessage;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class GenererEmpreinteMessage {
    private static Logger log = Logger.getLogger(GenererEmpreinteMessage.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, char[] cArray) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (cArray != null) {
                    ResultatEmpreinteMessage resultatEmpreinteMessage;
                    block10: {
                        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
                        cK_MECHANISM.mechanism = l2;
                        resultatEmpreinteMessage = new ResultatEmpreinteMessage("G\u00e9n\u00e9ration de l'empreinte d'un message avec " + TraitementsUtil.getNomAlgo(l2) + " (Initialisation (C_DigestInit))", "G\u00e9n\u00e9ration de l'empreinte d'un message avec " + TraitementsUtil.getNomAlgo(l2) + " (G\u00e9n\u00e9ration (C_Digest))");
                        byte[] byArray = null;
                        boolean bl = false;
                        try {
                            pKCS11.C_DigestInit(l, cK_MECHANISM);
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatEmpreinteMessage.setCodeRetour(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatEmpreinteMessage.setCodeRetour2(-1L);
                            resultatEmpreinteMessage.appendOperation2(" NON EXECUTEE!");
                        }
                        try {
                            if (bl) break block10;
                            byArray = pKCS11.C_Digest(l, new String(cArray).getBytes());
                            if (byArray != null) {
                                resultatEmpreinteMessage.setEmpreinte(TraitementsUtil.getHexadecimal(byArray, null));
                                break block10;
                            }
                            log.error((Object)"L'operation a retourne une empreinte nulle");
                            throw new ExceptionTraitement(26, "L'op\u00e9ration a retourn\u00e9 une empreinte nulle");
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatEmpreinteMessage.setCodeRetour2(pKCS11Exception.getErrorCode());
                        }
                    }
                    return resultatEmpreinteMessage;
                }
                log.error((Object)"Le message est nul");
                throw new ExceptionTraitement(26, "Le message est nul");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(26, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(26, "Une erreur inattendue est survenue");
        }
    }
}

